class DM_Mutator expands Mutator config(MOS_HASM);

var config string 	DMGameName,
			DMLeftMessage,
			DMEnteredMessage;
var config int		IdentifyRange,
			IdentifyZoomX;
var config string	NameString,
			ScoreString,
			FragString,
			DeathString,
			IntroSound,
			LogoTexture;
var config int		LogoDrawTime;

function PreBeginPlay ()
{
	Super.PreBeginPlay();
	SaveConfig();

	Level.Game.ScoreBoardType = Class'DM_SB';
	Level.Game.HUDType = Class'DM_HUD';
	Level.Game.GameName = DMGameName;
	Level.Game.LeftMessage = DMLeftMessage;
	Level.Game.EnteredMessage = DMEnteredMessage;

	AddMutator(Level.Spawn(class'DM_StatsMutator'));
	AddMutator(Level.Spawn(class'IP2Country'));

	SetTimer(1.0,True);
}

function bool AlwaysKeep(Actor Other) 
{	
	if (Other.IsA('PlayerPawn'))
        	{
		PlayerPawn(Other).PlayerReplicationInfoClass = class'PRI';
		return true;
		}
	if (NextMutator != None)
		return (NextMutator.AlwaysKeep(Other));	
	return false;
}

function Timer()
{
local Pawn P;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn') )
			{
			PRI(PlayerPawn(P).PlayerReplicationInfo).IdentifyRange = IdentifyRange;
			PRI(PlayerPawn(P).PlayerReplicationInfo).IdentifyZoomX = IdentifyZoomX;
			PRI(PlayerPawn(P).PlayerReplicationInfo).NameString = NameString;
			PRI(PlayerPawn(P).PlayerReplicationInfo).ScoreString = ScoreString;
			PRI(PlayerPawn(P).PlayerReplicationInfo).FragString = FragString;
			PRI(PlayerPawn(P).PlayerReplicationInfo).DeathString = DeathString;
			PRI(PlayerPawn(P).PlayerReplicationInfo).LogoTexture = LogoTexture;
			PRI(PlayerPawn(P).PlayerReplicationInfo).LogoPause = LogoDrawTime;
			PRI(PlayerPawn(P).PlayerReplicationInfo).IntroSound = IntroSound;
			}
		}
}

defaultproperties
{
DMGameName="-MOS- DeathMatch"
DMLeftMessage=" is a quitter!!!"
DMEnteredMessage=" joined the action!"
IdentifyRange=10000
IdentifyZoomX=1
NameString=Player
ScoreString=Score
FragString=Frags
DeathString=Deaths
LogoTexture="MOS_HASM_v1.MOSlogo"
LogoDrawTime=5
IntroSound="MOS_HASM_v1.THX"
}
